/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.hdcp;

import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.std.StdConnectionManager;
import com.quantumdata.std.SystemConsole;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;

public class HDCPCompliance
extends JApplet
implements IQDConsole,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton[] m_checkBoxes;
    private JPanel innerPanel;
    private JPanel innerPanel2;
    private JButton[] button;
    private JTextField[] m_textFields;
    String tempStr = "";
    String fileStr = "Unknown";
    RemoteInstrument m_instrument;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("HDCP GUI");
        jFrame.setDefaultCloseOperation(3);
        HDCPCompliance hDCPCompliance = new HDCPCompliance();
        hDCPCompliance.setInstrument(new StdConnectionManager(jFrame));
        hDCPCompliance.init();
        jFrame.getContentPane().add(hDCPCompliance);
        jFrame.setSize(250, 250);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setLocationRelativeTo(null);
    }

    public void setInstrument(StdConnectionManager stdConnectionManager) {
        String string;
        try {
            string = this.getCodeBase().getHost();
        }
        catch (NullPointerException nullPointerException) {
            String string2 = null;
            while (string2 == null || string2.equals("")) {
                string2 = (String)JOptionPane.showInputDialog(this, "Connect to.....", "Connect to Analyzer...", -1, null, null, "192.168.254.");
            }
            string = string2;
        }
        SocketConnection socketConnection = new SocketConnection(string);
        this.m_instrument = new RemoteInstrument(socketConnection, new SystemConsole());
        try {
            this.m_instrument.connect();
        }
        catch (InstrumentException instrumentException) {
            this.ShowErrorMessage("Unable to connect to: " + string);
            System.exit(0);
        }
        if (!this.m_instrument.isConnected()) {
            System.exit(1);
        }
        stdConnectionManager.addInstrument(this.m_instrument);
    }

    public void init() {
        int n;
        InstrumentResponse instrumentResponse;
        this.setInstrument(new StdConnectionManager(this));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBackground(Color.white);
        this.m_checkBoxes = new JRadioButton[7];
        this.m_textFields = new JTextField[3];
        this.button = new JButton[2];
        this.m_checkBoxes[0] = new JRadioButton("Repeater_1.1_Features");
        this.m_checkBoxes[0].putClientProperty("Command", "RPFT");
        this.m_checkBoxes[1] = new JRadioButton("Source_Out_OnlyRep");
        this.m_checkBoxes[1].putClientProperty("Command", "SOOR");
        this.m_checkBoxes[2] = new JRadioButton("Repeater_Out_OnlyRep");
        this.m_checkBoxes[2].putClientProperty("Command", "ROOR");
        this.m_checkBoxes[3] = new JRadioButton("Sink_1.1_Features");
        this.m_checkBoxes[3].putClientProperty("Command", "SRFT");
        this.m_checkBoxes[4] = new JRadioButton("Repeater_Audio_Support");
        this.m_checkBoxes[4].putClientProperty("Command", "RPAS");
        this.m_checkBoxes[5] = new JRadioButton("Sink_Audio_Support");
        this.m_checkBoxes[5].putClientProperty("Command", "SNAS");
        this.m_checkBoxes[6] = new JRadioButton("Repeater_HPD_Pulse");
        this.m_checkBoxes[6].putClientProperty("Command", "RHPD");
        for (int i = 0; i < this.m_checkBoxes.length; ++i) {
            instrumentResponse = this.m_instrument.sendCmd("CPTX:" + this.m_checkBoxes[i].getClientProperty("Command") + "?");
            if (Integer.parseInt(instrumentResponse.getResponse()) != 1) continue;
            this.m_checkBoxes[i].setSelected(true);
        }
        this.innerPanel = new JPanel(gridBagLayout);
        JComboBox<String> jComboBox = new JComboBox<String>();
        Dimension dimension = new Dimension(200, 40);
        String string = "DUT Type: ";
        jComboBox.putClientProperty("Command", "DUTT");
        jComboBox.addItem(new String(string + "Sink"));
        jComboBox.addItem(new String(string + "Source"));
        jComboBox.addItem(new String(string + "Repeater"));
        jComboBox.addItem(new String(string + "Repeater 3A/3B"));
        jComboBox.addItem(new String(string + "Repeater 3C"));
        jComboBox.setBackground(Color.white);
        jComboBox.setMinimumSize(dimension);
        jComboBox.setPreferredSize(dimension);
        instrumentResponse = this.m_instrument.sendCmd("CPTX:" + jComboBox.getClientProperty("Command") + "?");
        jComboBox.setSelectedIndex(Integer.parseInt(instrumentResponse.getResponse()));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        for (int i = 0; i < 7; ++i) {
            gridBagConstraints.gridx = i % 2 * 2;
            gridBagConstraints.gridy = i / 2;
            this.innerPanel.add((Component)this.m_checkBoxes[i], gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        this.innerPanel.add(jComboBox, gridBagConstraints);
        JLabel[] jLabelArray = new JLabel[]{new JLabel("Source_Max_KSV"), new JLabel("Repeater_Max_KSV"), new JLabel("Source_Authentication_Cnt")};
        this.m_textFields[0] = new JTextField("0");
        this.m_textFields[0].putClientProperty("Command", "SKSV");
        this.m_textFields[1] = new JTextField("0");
        this.m_textFields[1].putClientProperty("Command", "RKSV");
        this.m_textFields[2] = new JTextField("0");
        this.m_textFields[2].putClientProperty("Command", "SRAC");
        for (n = 0; n < this.m_textFields.length; ++n) {
            instrumentResponse = this.m_instrument.sendCmd("CPTX:" + this.m_textFields[n].getClientProperty("Command") + "?");
            this.m_textFields[n].setText(instrumentResponse.getResponse());
        }
        gridBagConstraints.gridwidth = 1;
        dimension = new Dimension(50, 30);
        for (n = 0; n < 3; ++n) {
            gridBagConstraints.gridx = n % 2 * 2;
            gridBagConstraints.gridy = 4 + n / 2;
            this.innerPanel.add((Component)jLabelArray[n], gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.m_textFields[n].setMinimumSize(dimension);
            this.m_textFields[n].setPreferredSize(dimension);
            this.innerPanel.add((Component)this.m_textFields[n], gridBagConstraints);
        }
        this.innerPanel2 = new JPanel();
        this.button[0] = new JButton("Send PCP");
        this.button[0].addActionListener(this);
        this.innerPanel2.add(this.button[0]);
        this.button[1] = new JButton("Create Reports");
        this.button[1].addActionListener(this);
        this.innerPanel2.add(this.button[1]);
        this.innerPanel2.setLayout(new GridLayout(1, 4, 0, 0));
        this.innerPanel2.setSize(new Dimension(400, 50));
        this.innerPanel2.setPreferredSize(new Dimension(400, 50));
        this.innerPanel2.setMaximumSize(new Dimension(400, 50));
        JScrollPane jScrollPane = new JScrollPane(this.innerPanel, 22, 30);
        jScrollPane.setLayout(new ScrollPaneLayout());
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add((Component)jScrollPane, "North");
        this.add((Component)this.innerPanel2, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        InstrumentResponse instrumentResponse;
        if (!this.m_instrument.isConnected()) {
            return;
        }
        if (actionEvent.getSource() == this.button[0]) {
            for (int i = 0; i < this.innerPanel.getComponentCount(); ++i) {
                if (this.innerPanel.getComponent(i) instanceof JRadioButton) {
                    this.tempStr = ((JRadioButton)this.innerPanel.getComponent(i)).getClientProperty("Command") + " ";
                    this.tempStr = ((JRadioButton)this.innerPanel.getComponent(i)).isSelected() ? this.tempStr + "1" : this.tempStr + "0";
                } else if (this.innerPanel.getComponent(i) instanceof JComboBox) {
                    this.tempStr = ((JComboBox)this.innerPanel.getComponent(i)).getClientProperty("Command") + " " + ((JComboBox)this.innerPanel.getComponent(i)).getSelectedIndex();
                } else if (this.innerPanel.getComponent(i) instanceof JTextField) {
                    this.tempStr = ((JTextField)this.innerPanel.getComponent(i)).getClientProperty("Command") + " " + ((JTextField)this.innerPanel.getComponent(i)).getText();
                }
                if (this.tempStr.length() != 0) {
                    try {
                        instrumentResponse = this.m_instrument.sendCmd("CPTX:" + this.tempStr);
                        if (instrumentResponse.isError()) {
                            this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                        }
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        this.ShowErrorMessage("Exception " + exception.getMessage() + " occurred.");
                    }
                }
                this.tempStr = "";
            }
        }
        if (actionEvent.getSource() == this.button[1]) {
            try {
                instrumentResponse = this.m_instrument.sendCmd("CPTX:CPTU", 300000);
                if (instrumentResponse.isError()) {
                    this.printGeneratorError(Integer.parseInt(instrumentResponse.getResponse()));
                }
            }
            catch (Exception exception) {
                this.ShowErrorMessage("Exception " + exception.getMessage() + " occurred.");
            }
        }
    }

    public void printGeneratorError(int n) {
        System.out.println("printGeneratorError errorValue = " + n);
        String string = "Unknown error " + n + " occurred.  May not affect testing.";
        if (n == 1) {
            string = "Error!  Message sent to test equipment was not recognized!  (Error 1)";
        }
        if (n == 4) {
            string = "Error!  Message sent to test equipment had an invalid number of arguments! (Error 4)";
        }
        if (n == 6) {
            string = "Error!  File could not be used.  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 6)";
        }
        if (n == 99) {
            string = "Internal error!  Please verify that a PCMCIA card is inserted and that software is up to date. (Error 99)";
        }
        if (n == 10031) {
            string = "Error!  Feature not enabled.  Please contact Quantum Data for licensing details. (Error 10031)";
        }
        if (n == 10300) {
            string = "CEC receive error - Message was not fully received. (Error 10300)";
        }
        if (n == 10301) {
            string = "CEC receive error - Timeout on the CEC line. (Error 10301)";
        }
        if (n == 10302) {
            string = "CEC receive error - Receive buffer error. (Error 10302)";
        }
        if (n == 10303) {
            string = "CEC receive error - Start bit timing incorrect. (Error 10303)";
        }
        if (n == 10304) {
            string = "CEC receive error - Receive buffer error - message dropped. (Error 10304)";
        }
        if (n == 10305) {
            string = "CEC receive error - Signal free time not adhered to. (Error 10305)";
        }
        if (n == 10310) {
            string = "CEC transmit error - CEC line error, send failed. (Error 10310)";
        }
        if (n == 10311) {
            string = "CEC transmit error - Arbitration was lost during send, send failed. (Error 10311)";
        }
        if (n == 10312) {
            string = "CEC transmit error - Message was not acknowledged.  Please retest. (Error 10312)";
        }
        if (n == 20000) {
            string = "Error!  Test equipment not connected to TME.  Please restart and connect.";
        }
        if (n == 20001) {
            string = "Error!  No value was entered by the tester when one was required!";
        }
        if (n == 20002) {
            string = "Error!  No selection was made by the tester when one was required!";
        }
        if (n == 20003) {
            string = "Error!  TME could not perform task (Exception occurred).";
        }
        if (n == 20005) {
            string = "Error!  Text input was not a number, when a number was expected.";
        }
        this.ShowErrorMessage(string);
    }

    private void ShowErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, "Error!", string, 0);
    }

    public void println(String string) {
    }
}

